//=================================================================
// This generates random enemies for the deep slums.
//=================================================================
Class SlumsEnemyGenerator extends Trigger;

var() Name EvilOrders;
var() bool bRandomDir;

function BeginPlay()
{
	GenerateSomeone();
}

function Timer()
{
	GenerateSomeone();
}

function GenerateSomeone()
{
	local SlumsPsychopath CP;
	local int r;
	local rotator rot;

	rot = Rotation;

	if(bRandomDir == true)
	{
		r=Rand(60000);
		rot.Yaw += r;
	}

	CP = Spawn(Class'SlumsPsychopath',,,Location, rot);
	CP.CPG = Self;
	CP.Orders = EvilOrders;

	r=Rand(24); // ========== Randomise fatness (within a small gap)

	CP.Fatness = r+116;

	r=Rand(4); // ========== Choose a head

	if((r == 0) || (r == 4)) //in case...
	{
		CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.MiscTex1';
	}
	else if(r == 1)
	{
		CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.TerroristTex0';
	}
	else if(r == 2)
	{
		CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.SmugglerTex0';
	}
	else if(r == 3)
	{
		CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.ThugMale2Tex0';
	}

	r=Rand(4); // ========== Pants...

	if((r == 0) || (r == 4))
	{
		CP.MultiSkins[1] = Texture'RPGMasterTest.Skins.SlumsPantsCyan';
	}
	else if(r == 1)
	{
		CP.MultiSkins[1] = Texture'RPGMasterTest.Skins.SlumsPantsGrey';
	}
	else if(r == 2)
	{
		//CP.MultiSkins[1] = Texture'RPGMasterTest.Skins.SlumsPantsNega';
		//Omitted and replaced by default for looking hilarious
	}
	else if(r == 3)
	{
		CP.MultiSkins[1] = Texture'RPGMasterTest.Skins.SlumsPantsPurp';
	}

	r=Rand(4); // ========== Top...

	if((r == 0) || (r == 4))
	{
		CP.MultiSkins[2] = Texture'RPGMasterTest.Skins.SlumsTopCyan';
	}
	else if(r == 1)
	{
		CP.MultiSkins[2] = Texture'RPGMasterTest.Skins.SlumsTopGrey';
	}
	else if(r == 2)
	{
		//CP.MultiSkins[2] = Texture'RPGMasterTest.Skins.SlumsTopNega';
		//Omitted and replaced by default for looking hilarious
	}
	else if(r == 3)
	{
		CP.MultiSkins[2] = Texture'RPGMasterTest.Skins.SlumsTopPurp';
	}

	r=Rand(3);

	if(r == 1) // ========== 1/3 chance of having something fancy
	{
		r = rand(4); // ========== What should the fancy thing be?

		if(r == 0)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.MJ12TroopTex4';
		}
		else if(r == 1)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.RiotCopTex3';
		}
		else if(r == 2)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.ThugMale3Tex3';
		}
		else if(r == 3)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.SoldierTex3';
		}
	}
}

defaultproperties
{
     bRandomDir=False
     EvilOrders=Standing
     Texture=Texture'Engine.S_Flag'
}
